package zio.aws.emr.model
import zio.aws.emr.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelStepsInfo(
    stepId: Optional[StepId] = Optional.Absent,
    status: Optional[zio.aws.emr.model.CancelStepsRequestStatus] =
      Optional.Absent,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CancelStepsInfo = {
    import CancelStepsInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CancelStepsInfo
      .builder()
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CancelStepsInfo.ReadOnly =
    zio.aws.emr.model.CancelStepsInfo.wrap(buildAwsValue())
}
object CancelStepsInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CancelStepsInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CancelStepsInfo =
      zio.aws.emr.model.CancelStepsInfo(
        stepId.map(value => value),
        status.map(value => value),
        reason.map(value => value)
      )
    def stepId: Optional[StepId]
    def status: Optional[zio.aws.emr.model.CancelStepsRequestStatus]
    def reason: Optional[String]
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.CancelStepsRequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsInfo
  ) extends zio.aws.emr.model.CancelStepsInfo.ReadOnly {
    override val stepId: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => zio.aws.emr.model.primitives.StepId(value))
    override val status: Optional[zio.aws.emr.model.CancelStepsRequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.CancelStepsRequestStatus.wrap(value))
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsInfo
  ): zio.aws.emr.model.CancelStepsInfo.ReadOnly = new Wrapper(impl)
}
