package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TerminateJobFlowsRequest(jobFlowIds: Iterable[XmlString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest = {
    import TerminateJobFlowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest
      .builder()
      .jobFlowIds(jobFlowIds.map { item =>
        XmlString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.TerminateJobFlowsRequest.ReadOnly =
    zio.aws.emr.model.TerminateJobFlowsRequest.wrap(buildAwsValue())
}
object TerminateJobFlowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.TerminateJobFlowsRequest =
      zio.aws.emr.model.TerminateJobFlowsRequest(jobFlowIds)
    def jobFlowIds: List[XmlString]
    def getJobFlowIds: ZIO[Any, Nothing, List[XmlString]] =
      ZIO.succeed(jobFlowIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest
  ) extends zio.aws.emr.model.TerminateJobFlowsRequest.ReadOnly {
    override val jobFlowIds: List[XmlString] = impl
      .jobFlowIds()
      .asScala
      .map { item =>
        zio.aws.emr.model.primitives.XmlString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest
  ): zio.aws.emr.model.TerminateJobFlowsRequest.ReadOnly = new Wrapper(impl)
}
