package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait Statistic {
  def unwrap: software.amazon.awssdk.services.emr.model.Statistic
}
object Statistic {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.Statistic
  ): zio.aws.emr.model.Statistic = value match {
    case software.amazon.awssdk.services.emr.model.Statistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.Statistic.SAMPLE_COUNT =>
      val r = SAMPLE_COUNT
      r
    case software.amazon.awssdk.services.emr.model.Statistic.AVERAGE =>
      val r = AVERAGE
      r
    case software.amazon.awssdk.services.emr.model.Statistic.SUM =>
      val r = SUM
      r
    case software.amazon.awssdk.services.emr.model.Statistic.MINIMUM =>
      val r = MINIMUM
      r
    case software.amazon.awssdk.services.emr.model.Statistic.MAXIMUM =>
      val r = MAXIMUM
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.Statistic {
    override def unwrap: software.amazon.awssdk.services.emr.model.Statistic =
      software.amazon.awssdk.services.emr.model.Statistic.UNKNOWN_TO_SDK_VERSION
  }
  case object SAMPLE_COUNT extends zio.aws.emr.model.Statistic {
    override def unwrap: software.amazon.awssdk.services.emr.model.Statistic =
      software.amazon.awssdk.services.emr.model.Statistic.SAMPLE_COUNT
  }
  case object AVERAGE extends zio.aws.emr.model.Statistic {
    override def unwrap: software.amazon.awssdk.services.emr.model.Statistic =
      software.amazon.awssdk.services.emr.model.Statistic.AVERAGE
  }
  case object SUM extends zio.aws.emr.model.Statistic {
    override def unwrap: software.amazon.awssdk.services.emr.model.Statistic =
      software.amazon.awssdk.services.emr.model.Statistic.SUM
  }
  case object MINIMUM extends zio.aws.emr.model.Statistic {
    override def unwrap: software.amazon.awssdk.services.emr.model.Statistic =
      software.amazon.awssdk.services.emr.model.Statistic.MINIMUM
  }
  case object MAXIMUM extends zio.aws.emr.model.Statistic {
    override def unwrap: software.amazon.awssdk.services.emr.model.Statistic =
      software.amazon.awssdk.services.emr.model.Statistic.MAXIMUM
  }
}
