package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait OnDemandCapacityReservationUsageStrategy {
  def unwrap: software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy
}
object OnDemandCapacityReservationUsageStrategy {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy
  ): zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy = value match {
    case software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy.USE_CAPACITY_RESERVATIONS_FIRST =>
      val r = `use-capacity-reservations-first`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy =
      software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `use-capacity-reservations-first`
      extends zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy =
      software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationUsageStrategy.USE_CAPACITY_RESERVATIONS_FIRST
  }
}
