package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetManagedScalingPolicyResponse(
    managedScalingPolicy: Optional[zio.aws.emr.model.ManagedScalingPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse = {
    import GetManagedScalingPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse
      .builder()
      .optionallyWith(managedScalingPolicy.map(value => value.buildAwsValue()))(
        _.managedScalingPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly =
    zio.aws.emr.model.GetManagedScalingPolicyResponse.wrap(buildAwsValue())
}
object GetManagedScalingPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetManagedScalingPolicyResponse =
      zio.aws.emr.model.GetManagedScalingPolicyResponse(
        managedScalingPolicy.map(value => value.asEditable)
      )
    def managedScalingPolicy
        : Optional[zio.aws.emr.model.ManagedScalingPolicy.ReadOnly]
    def getManagedScalingPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] =
      AwsError.unwrapOptionField("managedScalingPolicy", managedScalingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse
  ) extends zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly {
    override val managedScalingPolicy
        : Optional[zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedScalingPolicy())
        .map(value => zio.aws.emr.model.ManagedScalingPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse
  ): zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
