package zio.aws.emr.model
import java.lang.Integer
import zio.aws.emr.model.primitives.WholeNumber
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OnDemandResizingSpecification(
    timeoutDurationMinutes: WholeNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification = {
    import OnDemandResizingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
      .builder()
      .timeoutDurationMinutes(
        WholeNumber.unwrap(timeoutDurationMinutes): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly =
    zio.aws.emr.model.OnDemandResizingSpecification.wrap(buildAwsValue())
}
object OnDemandResizingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.OnDemandResizingSpecification =
      zio.aws.emr.model.OnDemandResizingSpecification(timeoutDurationMinutes)
    def timeoutDurationMinutes: WholeNumber
    def getTimeoutDurationMinutes: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(timeoutDurationMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
  ) extends zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly {
    override val timeoutDurationMinutes: WholeNumber =
      zio.aws.emr.model.primitives.WholeNumber(impl.timeoutDurationMinutes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification
  ): zio.aws.emr.model.OnDemandResizingSpecification.ReadOnly = new Wrapper(
    impl
  )
}
