package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Date, XmlString, XmlStringMaxLen256}
import scala.jdk.CollectionConverters._
final case class NotebookExecution(
    notebookExecutionId: Optional[XmlStringMaxLen256] = Optional.Absent,
    editorId: Optional[XmlStringMaxLen256] = Optional.Absent,
    executionEngine: Optional[zio.aws.emr.model.ExecutionEngineConfig] =
      Optional.Absent,
    notebookExecutionName: Optional[XmlStringMaxLen256] = Optional.Absent,
    notebookParams: Optional[XmlString] = Optional.Absent,
    status: Optional[zio.aws.emr.model.NotebookExecutionStatus] =
      Optional.Absent,
    startTime: Optional[Date] = Optional.Absent,
    endTime: Optional[Date] = Optional.Absent,
    arn: Optional[XmlStringMaxLen256] = Optional.Absent,
    outputNotebookURI: Optional[XmlString] = Optional.Absent,
    lastStateChangeReason: Optional[XmlString] = Optional.Absent,
    notebookInstanceSecurityGroupId: Optional[XmlStringMaxLen256] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.emr.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.NotebookExecution = {
    import NotebookExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.NotebookExecution
      .builder()
      .optionallyWith(
        notebookExecutionId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionId)
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(executionEngine.map(value => value.buildAwsValue()))(
        _.executionEngine
      )
      .optionallyWith(
        notebookExecutionName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionName)
      .optionallyWith(
        notebookParams.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.notebookParams)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Date.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        arn.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        outputNotebookURI.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.outputNotebookURI)
      .optionallyWith(
        lastStateChangeReason.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.lastStateChangeReason)
      .optionallyWith(
        notebookInstanceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceSecurityGroupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.NotebookExecution.ReadOnly =
    zio.aws.emr.model.NotebookExecution.wrap(buildAwsValue())
}
object NotebookExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.NotebookExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.NotebookExecution =
      zio.aws.emr.model.NotebookExecution(
        notebookExecutionId.map(value => value),
        editorId.map(value => value),
        executionEngine.map(value => value.asEditable),
        notebookExecutionName.map(value => value),
        notebookParams.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        arn.map(value => value),
        outputNotebookURI.map(value => value),
        lastStateChangeReason.map(value => value),
        notebookInstanceSecurityGroupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def notebookExecutionId: Optional[XmlStringMaxLen256]
    def editorId: Optional[XmlStringMaxLen256]
    def executionEngine
        : Optional[zio.aws.emr.model.ExecutionEngineConfig.ReadOnly]
    def notebookExecutionName: Optional[XmlStringMaxLen256]
    def notebookParams: Optional[XmlString]
    def status: Optional[zio.aws.emr.model.NotebookExecutionStatus]
    def startTime: Optional[Date]
    def endTime: Optional[Date]
    def arn: Optional[XmlStringMaxLen256]
    def outputNotebookURI: Optional[XmlString]
    def lastStateChangeReason: Optional[XmlString]
    def notebookInstanceSecurityGroupId: Optional[XmlStringMaxLen256]
    def tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]]
    def getNotebookExecutionId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionId", notebookExecutionId)
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getExecutionEngine
        : ZIO[Any, AwsError, zio.aws.emr.model.ExecutionEngineConfig.ReadOnly] =
      AwsError.unwrapOptionField("executionEngine", executionEngine)
    def getNotebookExecutionName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionName", notebookExecutionName)
    def getNotebookParams: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("notebookParams", notebookParams)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getArn: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("arn", arn)
    def getOutputNotebookURI: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("outputNotebookURI", outputNotebookURI)
    def getLastStateChangeReason: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("lastStateChangeReason", lastStateChangeReason)
    def getNotebookInstanceSecurityGroupId
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "notebookInstanceSecurityGroupId",
      notebookInstanceSecurityGroupId
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecution
  ) extends zio.aws.emr.model.NotebookExecution.ReadOnly {
    override val notebookExecutionId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookExecutionId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val editorId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val executionEngine
        : Optional[zio.aws.emr.model.ExecutionEngineConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionEngine())
        .map(value => zio.aws.emr.model.ExecutionEngineConfig.wrap(value))
    override val notebookExecutionName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookExecutionName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val notebookParams: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookParams())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val status: Optional[zio.aws.emr.model.NotebookExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.NotebookExecutionStatus.wrap(value))
    override val startTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val arn: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val outputNotebookURI: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.outputNotebookURI())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val lastStateChangeReason: Optional[XmlString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStateChangeReason())
        .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val notebookInstanceSecurityGroupId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecution
  ): zio.aws.emr.model.NotebookExecution.ReadOnly = new Wrapper(impl)
}
