package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Marker, Date}
import scala.jdk.CollectionConverters._
final case class ListClustersRequest(
    createdAfter: Optional[Date] = Optional.Absent,
    createdBefore: Optional[Date] = Optional.Absent,
    clusterStates: Optional[Iterable[zio.aws.emr.model.ClusterState]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListClustersRequest
      .builder()
      .optionallyWith(createdAfter.map(value => Date.unwrap(value): Instant))(
        _.createdAfter
      )
      .optionallyWith(createdBefore.map(value => Date.unwrap(value): Instant))(
        _.createdBefore
      )
      .optionallyWith(
        clusterStates.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.clusterStatesWithStrings)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListClustersRequest.ReadOnly =
    zio.aws.emr.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListClustersRequest =
      zio.aws.emr.model.ListClustersRequest(
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        clusterStates.map(value => value),
        marker.map(value => value)
      )
    def createdAfter: Optional[Date]
    def createdBefore: Optional[Date]
    def clusterStates: Optional[List[zio.aws.emr.model.ClusterState]]
    def marker: Optional[Marker]
    def getCreatedAfter: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getClusterStates
        : ZIO[Any, AwsError, List[zio.aws.emr.model.ClusterState]] =
      AwsError.unwrapOptionField("clusterStates", clusterStates)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListClustersRequest
  ) extends zio.aws.emr.model.ListClustersRequest.ReadOnly {
    override val createdAfter: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val createdBefore: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val clusterStates: Optional[List[zio.aws.emr.model.ClusterState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.ClusterState.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListClustersRequest
  ): zio.aws.emr.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
