package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceStateChangeReasonCode {
  def unwrap
      : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode
}
object InstanceStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode
  ): zio.aws.emr.model.InstanceStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.INSTANCE_FAILURE =>
      val r = INSTANCE_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.BOOTSTRAP_FAILURE =>
      val r = BOOTSTRAP_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.CLUSTER_TERMINATED =>
      val r = CLUSTER_TERMINATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.InstanceStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.emr.model.InstanceStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.INTERNAL_ERROR
  }
  case object VALIDATION_ERROR
      extends zio.aws.emr.model.InstanceStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.VALIDATION_ERROR
  }
  case object INSTANCE_FAILURE
      extends zio.aws.emr.model.InstanceStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.INSTANCE_FAILURE
  }
  case object BOOTSTRAP_FAILURE
      extends zio.aws.emr.model.InstanceStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.BOOTSTRAP_FAILURE
  }
  case object CLUSTER_TERMINATED
      extends zio.aws.emr.model.InstanceStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.InstanceStateChangeReasonCode.CLUSTER_TERMINATED
  }
}
