package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceStateChangeReason(
    code: Optional[zio.aws.emr.model.InstanceStateChangeReasonCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceStateChangeReason = {
    import InstanceStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceStateChangeReason.ReadOnly =
    zio.aws.emr.model.InstanceStateChangeReason.wrap(buildAwsValue())
}
object InstanceStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceStateChangeReason =
      zio.aws.emr.model.InstanceStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.emr.model.InstanceStateChangeReasonCode]
    def message: Optional[String]
    def getCode
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceStateChangeReasonCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceStateChangeReason
  ) extends zio.aws.emr.model.InstanceStateChangeReason.ReadOnly {
    override val code
        : Optional[zio.aws.emr.model.InstanceStateChangeReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.emr.model.InstanceStateChangeReasonCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceStateChangeReason
  ): zio.aws.emr.model.InstanceStateChangeReason.ReadOnly = new Wrapper(impl)
}
