package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStudioSessionMappingResponse(
    sessionMapping: Optional[zio.aws.emr.model.SessionMappingDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse = {
    import GetStudioSessionMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse
      .builder()
      .optionallyWith(sessionMapping.map(value => value.buildAwsValue()))(
        _.sessionMapping
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly =
    zio.aws.emr.model.GetStudioSessionMappingResponse.wrap(buildAwsValue())
}
object GetStudioSessionMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetStudioSessionMappingResponse =
      zio.aws.emr.model.GetStudioSessionMappingResponse(
        sessionMapping.map(value => value.asEditable)
      )
    def sessionMapping
        : Optional[zio.aws.emr.model.SessionMappingDetail.ReadOnly]
    def getSessionMapping
        : ZIO[Any, AwsError, zio.aws.emr.model.SessionMappingDetail.ReadOnly] =
      AwsError.unwrapOptionField("sessionMapping", sessionMapping)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse
  ) extends zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly {
    override val sessionMapping
        : Optional[zio.aws.emr.model.SessionMappingDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionMapping())
        .map(value => zio.aws.emr.model.SessionMappingDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse
  ): zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly = new Wrapper(
    impl
  )
}
