package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStudioSessionMappingRequest(
    studioId: XmlStringMaxLen256,
    identityId: Optional[XmlStringMaxLen256] = Optional.Absent,
    identityName: Optional[XmlStringMaxLen256] = Optional.Absent,
    identityType: zio.aws.emr.model.IdentityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest = {
    import GetStudioSessionMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest
      .builder()
      .studioId(XmlStringMaxLen256.unwrap(studioId): java.lang.String)
      .optionallyWith(
        identityId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.identityId)
      .optionallyWith(
        identityName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.identityName)
      .identityType(identityType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.GetStudioSessionMappingRequest.ReadOnly =
    zio.aws.emr.model.GetStudioSessionMappingRequest.wrap(buildAwsValue())
}
object GetStudioSessionMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetStudioSessionMappingRequest =
      zio.aws.emr.model.GetStudioSessionMappingRequest(
        studioId,
        identityId.map(value => value),
        identityName.map(value => value),
        identityType
      )
    def studioId: XmlStringMaxLen256
    def identityId: Optional[XmlStringMaxLen256]
    def identityName: Optional[XmlStringMaxLen256]
    def identityType: zio.aws.emr.model.IdentityType
    def getStudioId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(studioId)
    def getIdentityId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getIdentityName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("identityName", identityName)
    def getIdentityType: ZIO[Any, Nothing, zio.aws.emr.model.IdentityType] =
      ZIO.succeed(identityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest
  ) extends zio.aws.emr.model.GetStudioSessionMappingRequest.ReadOnly {
    override val studioId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.studioId())
    override val identityId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityType: zio.aws.emr.model.IdentityType =
      zio.aws.emr.model.IdentityType.wrap(impl.identityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest
  ): zio.aws.emr.model.GetStudioSessionMappingRequest.ReadOnly = new Wrapper(
    impl
  )
}
