package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailureDetails(
    reason: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    logFile: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.FailureDetails = {
    import FailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.FailureDetails
      .builder()
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(logFile.map(value => value: java.lang.String))(_.logFile)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.FailureDetails.ReadOnly =
    zio.aws.emr.model.FailureDetails.wrap(buildAwsValue())
}
object FailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.FailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.FailureDetails =
      zio.aws.emr.model.FailureDetails(
        reason.map(value => value),
        message.map(value => value),
        logFile.map(value => value)
      )
    def reason: Optional[String]
    def message: Optional[String]
    def logFile: Optional[String]
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getLogFile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFile", logFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.FailureDetails
  ) extends zio.aws.emr.model.FailureDetails.ReadOnly {
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val logFile: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logFile())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.FailureDetails
  ): zio.aws.emr.model.FailureDetails.ReadOnly = new Wrapper(impl)
}
