package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeNotebookExecutionRequest(
    notebookExecutionId: XmlStringMaxLen256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest = {
    import DescribeNotebookExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest
      .builder()
      .notebookExecutionId(
        XmlStringMaxLen256.unwrap(notebookExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeNotebookExecutionRequest.ReadOnly =
    zio.aws.emr.model.DescribeNotebookExecutionRequest.wrap(buildAwsValue())
}
object DescribeNotebookExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeNotebookExecutionRequest =
      zio.aws.emr.model.DescribeNotebookExecutionRequest(notebookExecutionId)
    def notebookExecutionId: XmlStringMaxLen256
    def getNotebookExecutionId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(notebookExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest
  ) extends zio.aws.emr.model.DescribeNotebookExecutionRequest.ReadOnly {
    override val notebookExecutionId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives
        .XmlStringMaxLen256(impl.notebookExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest
  ): zio.aws.emr.model.DescribeNotebookExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
