package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.emr.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ComparisonOperator
  ): zio.aws.emr.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.emr.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ComparisonOperator.GREATER_THAN_OR_EQUAL =>
      val r = GREATER_THAN_OR_EQUAL
      r
    case software.amazon.awssdk.services.emr.model.ComparisonOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.emr.model.ComparisonOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.emr.model.ComparisonOperator.LESS_THAN_OR_EQUAL =>
      val r = LESS_THAN_OR_EQUAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComparisonOperator =
      software.amazon.awssdk.services.emr.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object GREATER_THAN_OR_EQUAL
      extends zio.aws.emr.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComparisonOperator =
      software.amazon.awssdk.services.emr.model.ComparisonOperator.GREATER_THAN_OR_EQUAL
  }
  case object GREATER_THAN extends zio.aws.emr.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComparisonOperator =
      software.amazon.awssdk.services.emr.model.ComparisonOperator.GREATER_THAN
  }
  case object LESS_THAN extends zio.aws.emr.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComparisonOperator =
      software.amazon.awssdk.services.emr.model.ComparisonOperator.LESS_THAN
  }
  case object LESS_THAN_OR_EQUAL extends zio.aws.emr.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ComparisonOperator =
      software.amazon.awssdk.services.emr.model.ComparisonOperator.LESS_THAN_OR_EQUAL
  }
}
