package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ThroughputVal, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeSpecification(
    volumeType: String,
    iops: Optional[Integer] = Optional.Absent,
    sizeInGB: Integer,
    throughput: Optional[ThroughputVal] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.VolumeSpecification = {
    import VolumeSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.VolumeSpecification
      .builder()
      .volumeType(volumeType: java.lang.String)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .sizeInGB(sizeInGB: java.lang.Integer)
      .optionallyWith(
        throughput.map(value => ThroughputVal.unwrap(value): java.lang.Integer)
      )(_.throughput)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.VolumeSpecification.ReadOnly =
    zio.aws.emr.model.VolumeSpecification.wrap(buildAwsValue())
}
object VolumeSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.VolumeSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.VolumeSpecification =
      zio.aws.emr.model.VolumeSpecification(
        volumeType,
        iops.map(value => value),
        sizeInGB,
        throughput.map(value => value)
      )
    def volumeType: String
    def iops: Optional[Integer]
    def sizeInGB: Integer
    def throughput: Optional[ThroughputVal]
    def getVolumeType: ZIO[Any, Nothing, String] = ZIO.succeed(volumeType)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getSizeInGB: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGB)
    def getThroughput: ZIO[Any, AwsError, ThroughputVal] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.VolumeSpecification
  ) extends zio.aws.emr.model.VolumeSpecification.ReadOnly {
    override val volumeType: String = impl.volumeType(): String
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val sizeInGB: Integer = impl.sizeInGB(): Integer
    override val throughput: Optional[ThroughputVal] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => zio.aws.emr.model.primitives.ThroughputVal(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.VolumeSpecification
  ): zio.aws.emr.model.VolumeSpecification.ReadOnly = new Wrapper(impl)
}
