package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait AuthMode {
  def unwrap: software.amazon.awssdk.services.emr.model.AuthMode
}
object AuthMode {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.AuthMode
  ): zio.aws.emr.model.AuthMode = value match {
    case software.amazon.awssdk.services.emr.model.AuthMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.AuthMode.SSO =>
      val r = SSO
      r
    case software.amazon.awssdk.services.emr.model.AuthMode.IAM =>
      val r = IAM
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.AuthMode {
    override def unwrap: software.amazon.awssdk.services.emr.model.AuthMode =
      software.amazon.awssdk.services.emr.model.AuthMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SSO extends zio.aws.emr.model.AuthMode {
    override def unwrap: software.amazon.awssdk.services.emr.model.AuthMode =
      software.amazon.awssdk.services.emr.model.AuthMode.SSO
  }
  case object IAM extends zio.aws.emr.model.AuthMode {
    override def unwrap: software.amazon.awssdk.services.emr.model.AuthMode =
      software.amazon.awssdk.services.emr.model.AuthMode.IAM
  }
}
