package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Date, XmlStringMaxLen256}
import scala.jdk.CollectionConverters._
final case class NotebookExecutionSummary(
    notebookExecutionId: Optional[XmlStringMaxLen256] = Optional.Absent,
    editorId: Optional[XmlStringMaxLen256] = Optional.Absent,
    notebookExecutionName: Optional[XmlStringMaxLen256] = Optional.Absent,
    status: Optional[zio.aws.emr.model.NotebookExecutionStatus] =
      Optional.Absent,
    startTime: Optional[Date] = Optional.Absent,
    endTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.NotebookExecutionSummary = {
    import NotebookExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
      .builder()
      .optionallyWith(
        notebookExecutionId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionId)
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(
        notebookExecutionName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.notebookExecutionName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Date.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.NotebookExecutionSummary.ReadOnly =
    zio.aws.emr.model.NotebookExecutionSummary.wrap(buildAwsValue())
}
object NotebookExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.NotebookExecutionSummary =
      zio.aws.emr.model.NotebookExecutionSummary(
        notebookExecutionId.map(value => value),
        editorId.map(value => value),
        notebookExecutionName.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def notebookExecutionId: Optional[XmlStringMaxLen256]
    def editorId: Optional[XmlStringMaxLen256]
    def notebookExecutionName: Optional[XmlStringMaxLen256]
    def status: Optional[zio.aws.emr.model.NotebookExecutionStatus]
    def startTime: Optional[Date]
    def endTime: Optional[Date]
    def getNotebookExecutionId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionId", notebookExecutionId)
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getNotebookExecutionName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("notebookExecutionName", notebookExecutionName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
  ) extends zio.aws.emr.model.NotebookExecutionSummary.ReadOnly {
    override val notebookExecutionId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookExecutionId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val editorId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val notebookExecutionName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookExecutionName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val status: Optional[zio.aws.emr.model.NotebookExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.NotebookExecutionStatus.wrap(value))
    override val startTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.NotebookExecutionSummary
  ): zio.aws.emr.model.NotebookExecutionSummary.ReadOnly = new Wrapper(impl)
}
