package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceGroupsRequest(
    clusterId: Optional[ClusterId] = Optional.Absent,
    instanceGroups: Optional[
      Iterable[zio.aws.emr.model.InstanceGroupModifyConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest = {
    import ModifyInstanceGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest
      .builder()
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        instanceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceGroups)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ModifyInstanceGroupsRequest.ReadOnly =
    zio.aws.emr.model.ModifyInstanceGroupsRequest.wrap(buildAwsValue())
}
object ModifyInstanceGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ModifyInstanceGroupsRequest =
      zio.aws.emr.model.ModifyInstanceGroupsRequest(
        clusterId.map(value => value),
        instanceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterId: Optional[ClusterId]
    def instanceGroups
        : Optional[List[zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly]]
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getInstanceGroups: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceGroups", instanceGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest
  ) extends zio.aws.emr.model.ModifyInstanceGroupsRequest.ReadOnly {
    override val clusterId: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterId())
      .map(value => zio.aws.emr.model.primitives.ClusterId(value))
    override val instanceGroups
        : Optional[List[zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceGroupModifyConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest
  ): zio.aws.emr.model.ModifyInstanceGroupsRequest.ReadOnly = new Wrapper(impl)
}
