package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyClusterRequest(
    clusterId: String,
    stepConcurrencyLevel: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ModifyClusterRequest = {
    import ModifyClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ModifyClusterRequest
      .builder()
      .clusterId(clusterId: java.lang.String)
      .optionallyWith(
        stepConcurrencyLevel.map(value => value: java.lang.Integer)
      )(_.stepConcurrencyLevel)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ModifyClusterRequest.ReadOnly =
    zio.aws.emr.model.ModifyClusterRequest.wrap(buildAwsValue())
}
object ModifyClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ModifyClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ModifyClusterRequest = zio.aws.emr.model
      .ModifyClusterRequest(clusterId, stepConcurrencyLevel.map(value => value))
    def clusterId: String
    def stepConcurrencyLevel: Optional[Integer]
    def getClusterId: ZIO[Any, Nothing, String] = ZIO.succeed(clusterId)
    def getStepConcurrencyLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stepConcurrencyLevel", stepConcurrencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ModifyClusterRequest
  ) extends zio.aws.emr.model.ModifyClusterRequest.ReadOnly {
    override val clusterId: String = impl.clusterId(): String
    override val stepConcurrencyLevel: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.stepConcurrencyLevel())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ModifyClusterRequest
  ): zio.aws.emr.model.ModifyClusterRequest.ReadOnly = new Wrapper(impl)
}
