package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricDimension(
    key: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.MetricDimension = {
    import MetricDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.MetricDimension
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.MetricDimension.ReadOnly =
    zio.aws.emr.model.MetricDimension.wrap(buildAwsValue())
}
object MetricDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.MetricDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.MetricDimension = zio.aws.emr.model
      .MetricDimension(key.map(value => value), value.map(value => value))
    def key: Optional[String]
    def value: Optional[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.MetricDimension
  ) extends zio.aws.emr.model.MetricDimension.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.MetricDimension
  ): zio.aws.emr.model.MetricDimension.ReadOnly = new Wrapper(impl)
}
