package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.Date
import scala.jdk.CollectionConverters._
final case class InstanceTimeline(
    creationDateTime: Optional[Date] = Optional.Absent,
    readyDateTime: Optional[Date] = Optional.Absent,
    endDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceTimeline = {
    import InstanceTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceTimeline
      .builder()
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(readyDateTime.map(value => Date.unwrap(value): Instant))(
        _.readyDateTime
      )
      .optionallyWith(endDateTime.map(value => Date.unwrap(value): Instant))(
        _.endDateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceTimeline.ReadOnly =
    zio.aws.emr.model.InstanceTimeline.wrap(buildAwsValue())
}
object InstanceTimeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceTimeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceTimeline =
      zio.aws.emr.model.InstanceTimeline(
        creationDateTime.map(value => value),
        readyDateTime.map(value => value),
        endDateTime.map(value => value)
      )
    def creationDateTime: Optional[Date]
    def readyDateTime: Optional[Date]
    def endDateTime: Optional[Date]
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getReadyDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("readyDateTime", readyDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceTimeline
  ) extends zio.aws.emr.model.InstanceTimeline.ReadOnly {
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val readyDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.readyDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceTimeline
  ): zio.aws.emr.model.InstanceTimeline.ReadOnly = new Wrapper(impl)
}
