package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicyDescription(
    status: Optional[zio.aws.emr.model.AutoScalingPolicyStatus] =
      Optional.Absent,
    constraints: Optional[zio.aws.emr.model.ScalingConstraints] =
      Optional.Absent,
    rules: Optional[Iterable[zio.aws.emr.model.ScalingRule]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription = {
    import AutoScalingPolicyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly =
    zio.aws.emr.model.AutoScalingPolicyDescription.wrap(buildAwsValue())
}
object AutoScalingPolicyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AutoScalingPolicyDescription =
      zio.aws.emr.model.AutoScalingPolicyDescription(
        status.map(value => value.asEditable),
        constraints.map(value => value.asEditable),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Optional[zio.aws.emr.model.AutoScalingPolicyStatus.ReadOnly]
    def constraints: Optional[zio.aws.emr.model.ScalingConstraints.ReadOnly]
    def rules: Optional[List[zio.aws.emr.model.ScalingRule.ReadOnly]]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.emr.model.ScalingConstraints.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.emr.model.ScalingRule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription
  ) extends zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly {
    override val status
        : Optional[zio.aws.emr.model.AutoScalingPolicyStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.AutoScalingPolicyStatus.wrap(value))
    override val constraints
        : Optional[zio.aws.emr.model.ScalingConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.emr.model.ScalingConstraints.wrap(value))
    override val rules: Optional[List[zio.aws.emr.model.ScalingRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.ScalingRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription
  ): zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly = new Wrapper(impl)
}
