package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StepStatus(
    state: Optional[zio.aws.emr.model.StepState] = Optional.Absent,
    stateChangeReason: Optional[zio.aws.emr.model.StepStateChangeReason] =
      Optional.Absent,
    failureDetails: Optional[zio.aws.emr.model.FailureDetails] =
      Optional.Absent,
    timeline: Optional[zio.aws.emr.model.StepTimeline] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.StepStatus = {
    import StepStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepStatus.ReadOnly =
    zio.aws.emr.model.StepStatus.wrap(buildAwsValue())
}
object StepStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepStatus = zio.aws.emr.model.StepStatus(
      state.map(value => value),
      stateChangeReason.map(value => value.asEditable),
      failureDetails.map(value => value.asEditable),
      timeline.map(value => value.asEditable)
    )
    def state: Optional[zio.aws.emr.model.StepState]
    def stateChangeReason
        : Optional[zio.aws.emr.model.StepStateChangeReason.ReadOnly]
    def failureDetails: Optional[zio.aws.emr.model.FailureDetails.ReadOnly]
    def timeline: Optional[zio.aws.emr.model.StepTimeline.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.emr.model.StepState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason
        : ZIO[Any, AwsError, zio.aws.emr.model.StepStateChangeReason.ReadOnly] =
      AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getFailureDetails
        : ZIO[Any, AwsError, zio.aws.emr.model.FailureDetails.ReadOnly] =
      AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.emr.model.StepTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepStatus
  ) extends zio.aws.emr.model.StepStatus.ReadOnly {
    override val state: Optional[zio.aws.emr.model.StepState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.emr.model.StepState.wrap(value))
    override val stateChangeReason
        : Optional[zio.aws.emr.model.StepStateChangeReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeReason())
        .map(value => zio.aws.emr.model.StepStateChangeReason.wrap(value))
    override val failureDetails
        : Optional[zio.aws.emr.model.FailureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDetails())
        .map(value => zio.aws.emr.model.FailureDetails.wrap(value))
    override val timeline: Optional[zio.aws.emr.model.StepTimeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeline())
        .map(value => zio.aws.emr.model.StepTimeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepStatus
  ): zio.aws.emr.model.StepStatus.ReadOnly = new Wrapper(impl)
}
