package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait StepCancellationOption {
  def unwrap: software.amazon.awssdk.services.emr.model.StepCancellationOption
}
object StepCancellationOption {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.StepCancellationOption
  ): zio.aws.emr.model.StepCancellationOption = value match {
    case software.amazon.awssdk.services.emr.model.StepCancellationOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.StepCancellationOption.SEND_INTERRUPT =>
      val r = SEND_INTERRUPT
      r
    case software.amazon.awssdk.services.emr.model.StepCancellationOption.TERMINATE_PROCESS =>
      val r = TERMINATE_PROCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.StepCancellationOption {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.StepCancellationOption =
      software.amazon.awssdk.services.emr.model.StepCancellationOption.UNKNOWN_TO_SDK_VERSION
  }
  case object SEND_INTERRUPT extends zio.aws.emr.model.StepCancellationOption {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.StepCancellationOption =
      software.amazon.awssdk.services.emr.model.StepCancellationOption.SEND_INTERRUPT
  }
  case object TERMINATE_PROCESS
      extends zio.aws.emr.model.StepCancellationOption {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.StepCancellationOption =
      software.amazon.awssdk.services.emr.model.StepCancellationOption.TERMINATE_PROCESS
  }
}
