package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{WholeNumber, XmlStringMaxLen256}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceFleetConfig(
    name: Optional[XmlStringMaxLen256] = Optional.Absent,
    instanceFleetType: zio.aws.emr.model.InstanceFleetType,
    targetOnDemandCapacity: Optional[WholeNumber] = Optional.Absent,
    targetSpotCapacity: Optional[WholeNumber] = Optional.Absent,
    instanceTypeConfigs: Optional[
      Iterable[zio.aws.emr.model.InstanceTypeConfig]
    ] = Optional.Absent,
    launchSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetConfig = {
    import InstanceFleetConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetConfig
      .builder()
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .instanceFleetType(instanceFleetType.unwrap)
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .optionallyWith(
        instanceTypeConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeConfigs)
      .optionallyWith(launchSpecifications.map(value => value.buildAwsValue()))(
        _.launchSpecifications
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetConfig.ReadOnly =
    zio.aws.emr.model.InstanceFleetConfig.wrap(buildAwsValue())
}
object InstanceFleetConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetConfig =
      zio.aws.emr.model.InstanceFleetConfig(
        name.map(value => value),
        instanceFleetType,
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value),
        instanceTypeConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchSpecifications.map(value => value.asEditable)
      )
    def name: Optional[XmlStringMaxLen256]
    def instanceFleetType: zio.aws.emr.model.InstanceFleetType
    def targetOnDemandCapacity: Optional[WholeNumber]
    def targetSpotCapacity: Optional[WholeNumber]
    def instanceTypeConfigs
        : Optional[List[zio.aws.emr.model.InstanceTypeConfig.ReadOnly]]
    def launchSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceFleetType
        : ZIO[Any, Nothing, zio.aws.emr.model.InstanceFleetType] =
      ZIO.succeed(instanceFleetType)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
    def getInstanceTypeConfigs: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceTypeConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTypeConfigs", instanceTypeConfigs)
    def getLaunchSpecifications: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecifications", launchSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetConfig
  ) extends zio.aws.emr.model.InstanceFleetConfig.ReadOnly {
    override val name: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceFleetType: zio.aws.emr.model.InstanceFleetType =
      zio.aws.emr.model.InstanceFleetType.wrap(impl.instanceFleetType())
    override val targetOnDemandCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetOnDemandCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSpotCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val instanceTypeConfigs
        : Optional[List[zio.aws.emr.model.InstanceTypeConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTypeConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceTypeConfig.wrap(item)
          }.toList
        )
    override val launchSpecifications: Optional[
      zio.aws.emr.model.InstanceFleetProvisioningSpecifications.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchSpecifications())
      .map(value =>
        zio.aws.emr.model.InstanceFleetProvisioningSpecifications.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetConfig
  ): zio.aws.emr.model.InstanceFleetConfig.ReadOnly = new Wrapper(impl)
}
