package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  OptionalArnType,
  ArnType,
  Integer,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterSummary(
    id: Optional[ClusterId] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.emr.model.ClusterStatus] = Optional.Absent,
    normalizedInstanceHours: Optional[Integer] = Optional.Absent,
    clusterArn: Optional[ArnType] = Optional.Absent,
    outpostArn: Optional[OptionalArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ClusterSummary = {
    import ClusterSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ClusterSummary
      .builder()
      .optionallyWith(
        id.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        normalizedInstanceHours.map(value => value: java.lang.Integer)
      )(_.normalizedInstanceHours)
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        outpostArn.map(value => OptionalArnType.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ClusterSummary.ReadOnly =
    zio.aws.emr.model.ClusterSummary.wrap(buildAwsValue())
}
object ClusterSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ClusterSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ClusterSummary =
      zio.aws.emr.model.ClusterSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value.asEditable),
        normalizedInstanceHours.map(value => value),
        clusterArn.map(value => value),
        outpostArn.map(value => value)
      )
    def id: Optional[ClusterId]
    def name: Optional[String]
    def status: Optional[zio.aws.emr.model.ClusterStatus.ReadOnly]
    def normalizedInstanceHours: Optional[Integer]
    def clusterArn: Optional[ArnType]
    def outpostArn: Optional[OptionalArnType]
    def getId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.ClusterStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getNormalizedInstanceHours: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("normalizedInstanceHours", normalizedInstanceHours)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getOutpostArn: ZIO[Any, AwsError, OptionalArnType] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ClusterSummary
  ) extends zio.aws.emr.model.ClusterSummary.ReadOnly {
    override val id: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.emr.model.primitives.ClusterId(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[zio.aws.emr.model.ClusterStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.ClusterStatus.wrap(value))
    override val normalizedInstanceHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.normalizedInstanceHours())
        .map(value => value: Integer)
    override val clusterArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
    override val outpostArn: Optional[OptionalArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => zio.aws.emr.model.primitives.OptionalArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ClusterSummary
  ): zio.aws.emr.model.ClusterSummary.ReadOnly = new Wrapper(impl)
}
