package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterStateChangeReason(
    code: Optional[zio.aws.emr.model.ClusterStateChangeReasonCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ClusterStateChangeReason = {
    import ClusterStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ClusterStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ClusterStateChangeReason.ReadOnly =
    zio.aws.emr.model.ClusterStateChangeReason.wrap(buildAwsValue())
}
object ClusterStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ClusterStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ClusterStateChangeReason =
      zio.aws.emr.model.ClusterStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.emr.model.ClusterStateChangeReasonCode]
    def message: Optional[String]
    def getCode
        : ZIO[Any, AwsError, zio.aws.emr.model.ClusterStateChangeReasonCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ClusterStateChangeReason
  ) extends zio.aws.emr.model.ClusterStateChangeReason.ReadOnly {
    override val code
        : Optional[zio.aws.emr.model.ClusterStateChangeReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.emr.model.ClusterStateChangeReasonCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ClusterStateChangeReason
  ): zio.aws.emr.model.ClusterStateChangeReason.ReadOnly = new Wrapper(impl)
}
