package zio.aws.emr.model
import zio.aws.emr.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EbsConfiguration(
    ebsBlockDeviceConfigs: Optional[
      Iterable[zio.aws.emr.model.EbsBlockDeviceConfig]
    ] = Optional.Absent,
    ebsOptimized: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.EbsConfiguration = {
    import EbsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.EbsConfiguration
      .builder()
      .optionallyWith(
        ebsBlockDeviceConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsBlockDeviceConfigs)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.EbsConfiguration.ReadOnly =
    zio.aws.emr.model.EbsConfiguration.wrap(buildAwsValue())
}
object EbsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.EbsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.EbsConfiguration =
      zio.aws.emr.model.EbsConfiguration(
        ebsBlockDeviceConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value)
      )
    def ebsBlockDeviceConfigs
        : Optional[List[zio.aws.emr.model.EbsBlockDeviceConfig.ReadOnly]]
    def ebsOptimized: Optional[BooleanObject]
    def getEbsBlockDeviceConfigs: ZIO[Any, AwsError, List[
      zio.aws.emr.model.EbsBlockDeviceConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ebsBlockDeviceConfigs", ebsBlockDeviceConfigs)
    def getEbsOptimized: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.EbsConfiguration
  ) extends zio.aws.emr.model.EbsConfiguration.ReadOnly {
    override val ebsBlockDeviceConfigs
        : Optional[List[zio.aws.emr.model.EbsBlockDeviceConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsBlockDeviceConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.EbsBlockDeviceConfig.wrap(item)
          }.toList
        )
    override val ebsOptimized: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.EbsConfiguration
  ): zio.aws.emr.model.EbsConfiguration.ReadOnly = new Wrapper(impl)
}
