package zio.aws.emr
import zio.aws.emr.model.PutManagedScalingPolicyResponse.ReadOnly
import software.amazon.awssdk.services.emr.EmrAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.emr.model.{
  RunJobFlowRequest,
  AddInstanceGroupsRequest,
  ListNotebookExecutionsRequest,
  AddInstanceFleetRequest,
  PutBlockPublicAccessConfigurationRequest,
  RemoveManagedScalingPolicyRequest,
  DeleteSecurityConfigurationRequest,
  CreateStudioRequest,
  ListBootstrapActionsRequest,
  GetAutoTerminationPolicyRequest,
  StartNotebookExecutionRequest,
  ListInstancesRequest,
  PutManagedScalingPolicyRequest,
  SetTerminationProtectionRequest,
  DescribeSecurityConfigurationRequest,
  ListStepsRequest,
  UpdateStudioSessionMappingRequest,
  DescribeStepRequest,
  PutAutoTerminationPolicyRequest,
  SetVisibleToAllUsersRequest,
  AddTagsRequest,
  GetBlockPublicAccessConfigurationRequest,
  UpdateStudioRequest,
  TerminateJobFlowsRequest,
  ModifyInstanceGroupsRequest,
  CancelStepsRequest,
  ListStudiosRequest,
  RemoveAutoScalingPolicyRequest,
  RemoveAutoTerminationPolicyRequest,
  DeleteStudioSessionMappingRequest,
  PutAutoScalingPolicyRequest,
  ModifyInstanceFleetRequest,
  ListInstanceGroupsRequest,
  StopNotebookExecutionRequest,
  DescribeClusterRequest,
  ListReleaseLabelsRequest,
  GetStudioSessionMappingRequest,
  DescribeReleaseLabelRequest,
  ListStudioSessionMappingsRequest,
  AddJobFlowStepsRequest,
  ModifyClusterRequest,
  DescribeStudioRequest,
  ListSecurityConfigurationsRequest,
  DescribeNotebookExecutionRequest,
  RemoveTagsRequest,
  GetManagedScalingPolicyRequest,
  ListClustersRequest,
  CreateSecurityConfigurationRequest,
  CreateStudioSessionMappingRequest,
  ListInstanceFleetsRequest,
  DeleteStudioRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object EmrMock extends Mock[Emr] {
  object GetBlockPublicAccessConfiguration
      extends Effect[
        GetBlockPublicAccessConfigurationRequest,
        AwsError,
        zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly
      ]
  object ListStudioSessionMappings
      extends Stream[
        ListStudioSessionMappingsRequest,
        AwsError,
        zio.aws.emr.model.SessionMappingSummary.ReadOnly
      ]
  object ListStudioSessionMappingsPaginated
      extends Effect[
        ListStudioSessionMappingsRequest,
        AwsError,
        zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly
      ]
  object CreateStudio
      extends Effect[
        CreateStudioRequest,
        AwsError,
        zio.aws.emr.model.CreateStudioResponse.ReadOnly
      ]
  object DescribeNotebookExecution
      extends Effect[
        DescribeNotebookExecutionRequest,
        AwsError,
        zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly
      ]
  object StopNotebookExecution
      extends Effect[StopNotebookExecutionRequest, AwsError, Unit]
  object ListBootstrapActions
      extends Stream[
        ListBootstrapActionsRequest,
        AwsError,
        zio.aws.emr.model.Command.ReadOnly
      ]
  object ListBootstrapActionsPaginated
      extends Effect[
        ListBootstrapActionsRequest,
        AwsError,
        zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly
      ]
  object ListReleaseLabels
      extends Stream[ListReleaseLabelsRequest, AwsError, String]
  object ListReleaseLabelsPaginated
      extends Effect[
        ListReleaseLabelsRequest,
        AwsError,
        zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly
      ]
  object SetTerminationProtection
      extends Effect[SetTerminationProtectionRequest, AwsError, Unit]
  object DescribeStep
      extends Effect[
        DescribeStepRequest,
        AwsError,
        zio.aws.emr.model.DescribeStepResponse.ReadOnly
      ]
  object CancelSteps
      extends Effect[
        CancelStepsRequest,
        AwsError,
        zio.aws.emr.model.CancelStepsResponse.ReadOnly
      ]
  object ListInstances
      extends Stream[
        ListInstancesRequest,
        AwsError,
        zio.aws.emr.model.Instance.ReadOnly
      ]
  object ListInstancesPaginated
      extends Effect[
        ListInstancesRequest,
        AwsError,
        zio.aws.emr.model.ListInstancesResponse.ReadOnly
      ]
  object DescribeStudio
      extends Effect[
        DescribeStudioRequest,
        AwsError,
        zio.aws.emr.model.DescribeStudioResponse.ReadOnly
      ]
  object AddTags
      extends Effect[
        AddTagsRequest,
        AwsError,
        zio.aws.emr.model.AddTagsResponse.ReadOnly
      ]
  object PutAutoScalingPolicy
      extends Effect[
        PutAutoScalingPolicyRequest,
        AwsError,
        zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly
      ]
  object RemoveAutoScalingPolicy
      extends Effect[
        RemoveAutoScalingPolicyRequest,
        AwsError,
        zio.aws.emr.model.RemoveAutoScalingPolicyResponse.ReadOnly
      ]
  object SetVisibleToAllUsers
      extends Effect[SetVisibleToAllUsersRequest, AwsError, Unit]
  object GetStudioSessionMapping
      extends Effect[
        GetStudioSessionMappingRequest,
        AwsError,
        zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly
      ]
  object ListSecurityConfigurations
      extends Stream[
        ListSecurityConfigurationsRequest,
        AwsError,
        zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly
      ]
  object ListSecurityConfigurationsPaginated
      extends Effect[
        ListSecurityConfigurationsRequest,
        AwsError,
        zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly
      ]
  object DeleteStudioSessionMapping
      extends Effect[DeleteStudioSessionMappingRequest, AwsError, Unit]
  object PutAutoTerminationPolicy
      extends Effect[
        PutAutoTerminationPolicyRequest,
        AwsError,
        zio.aws.emr.model.PutAutoTerminationPolicyResponse.ReadOnly
      ]
  object ModifyInstanceFleet
      extends Effect[ModifyInstanceFleetRequest, AwsError, Unit]
  object RemoveTags
      extends Effect[
        RemoveTagsRequest,
        AwsError,
        zio.aws.emr.model.RemoveTagsResponse.ReadOnly
      ]
  object ListInstanceGroups
      extends Stream[
        ListInstanceGroupsRequest,
        AwsError,
        zio.aws.emr.model.InstanceGroup.ReadOnly
      ]
  object ListInstanceGroupsPaginated
      extends Effect[
        ListInstanceGroupsRequest,
        AwsError,
        zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly
      ]
  object GetAutoTerminationPolicy
      extends Effect[
        GetAutoTerminationPolicyRequest,
        AwsError,
        zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly
      ]
  object UpdateStudioSessionMapping
      extends Effect[UpdateStudioSessionMappingRequest, AwsError, Unit]
  object PutBlockPublicAccessConfiguration
      extends Effect[
        PutBlockPublicAccessConfigurationRequest,
        AwsError,
        zio.aws.emr.model.PutBlockPublicAccessConfigurationResponse.ReadOnly
      ]
  object UpdateStudio extends Effect[UpdateStudioRequest, AwsError, Unit]
  object PutManagedScalingPolicy
      extends Effect[PutManagedScalingPolicyRequest, AwsError, ReadOnly]
  object ListSteps
      extends Stream[
        ListStepsRequest,
        AwsError,
        zio.aws.emr.model.StepSummary.ReadOnly
      ]
  object ListStepsPaginated
      extends Effect[
        ListStepsRequest,
        AwsError,
        zio.aws.emr.model.ListStepsResponse.ReadOnly
      ]
  object ListStudios
      extends Stream[
        ListStudiosRequest,
        AwsError,
        zio.aws.emr.model.StudioSummary.ReadOnly
      ]
  object ListStudiosPaginated
      extends Effect[
        ListStudiosRequest,
        AwsError,
        zio.aws.emr.model.ListStudiosResponse.ReadOnly
      ]
  object AddJobFlowSteps
      extends Effect[
        AddJobFlowStepsRequest,
        AwsError,
        zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly
      ]
  object CreateSecurityConfiguration
      extends Effect[
        CreateSecurityConfigurationRequest,
        AwsError,
        zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly
      ]
  object AddInstanceFleet
      extends Effect[
        AddInstanceFleetRequest,
        AwsError,
        zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly
      ]
  object ModifyCluster
      extends Effect[
        ModifyClusterRequest,
        AwsError,
        zio.aws.emr.model.ModifyClusterResponse.ReadOnly
      ]
  object DeleteSecurityConfiguration
      extends Effect[
        DeleteSecurityConfigurationRequest,
        AwsError,
        zio.aws.emr.model.DeleteSecurityConfigurationResponse.ReadOnly
      ]
  object CreateStudioSessionMapping
      extends Effect[CreateStudioSessionMappingRequest, AwsError, Unit]
  object DescribeSecurityConfiguration
      extends Effect[
        DescribeSecurityConfigurationRequest,
        AwsError,
        zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly
      ]
  object DescribeCluster
      extends Effect[
        DescribeClusterRequest,
        AwsError,
        zio.aws.emr.model.DescribeClusterResponse.ReadOnly
      ]
  object ListClusters
      extends Stream[
        ListClustersRequest,
        AwsError,
        zio.aws.emr.model.ClusterSummary.ReadOnly
      ]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.emr.model.ListClustersResponse.ReadOnly
      ]
  object AddInstanceGroups
      extends Effect[
        AddInstanceGroupsRequest,
        AwsError,
        zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly
      ]
  object DeleteStudio extends Effect[DeleteStudioRequest, AwsError, Unit]
  object RunJobFlow
      extends Effect[
        RunJobFlowRequest,
        AwsError,
        zio.aws.emr.model.RunJobFlowResponse.ReadOnly
      ]
  object RemoveAutoTerminationPolicy
      extends Effect[
        RemoveAutoTerminationPolicyRequest,
        AwsError,
        zio.aws.emr.model.RemoveAutoTerminationPolicyResponse.ReadOnly
      ]
  object DescribeReleaseLabel
      extends Effect[
        DescribeReleaseLabelRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly,
          String
        ]
      ]
  object DescribeReleaseLabelPaginated
      extends Effect[
        DescribeReleaseLabelRequest,
        AwsError,
        zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly
      ]
  object StartNotebookExecution
      extends Effect[
        StartNotebookExecutionRequest,
        AwsError,
        zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly
      ]
  object RemoveManagedScalingPolicy
      extends Effect[
        RemoveManagedScalingPolicyRequest,
        AwsError,
        zio.aws.emr.model.RemoveManagedScalingPolicyResponse.ReadOnly
      ]
  object ModifyInstanceGroups
      extends Effect[ModifyInstanceGroupsRequest, AwsError, Unit]
  object ListNotebookExecutions
      extends Stream[
        ListNotebookExecutionsRequest,
        AwsError,
        zio.aws.emr.model.NotebookExecutionSummary.ReadOnly
      ]
  object ListNotebookExecutionsPaginated
      extends Effect[
        ListNotebookExecutionsRequest,
        AwsError,
        zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly
      ]
  object TerminateJobFlows
      extends Effect[TerminateJobFlowsRequest, AwsError, Unit]
  object ListInstanceFleets
      extends Stream[
        ListInstanceFleetsRequest,
        AwsError,
        zio.aws.emr.model.InstanceFleet.ReadOnly
      ]
  object ListInstanceFleetsPaginated
      extends Effect[
        ListInstanceFleetsRequest,
        AwsError,
        zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly
      ]
  object GetManagedScalingPolicy
      extends Effect[
        GetManagedScalingPolicyRequest,
        AwsError,
        zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Emr] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Emr] { rts =>
        zio.ZIO.succeed {
          new Emr {
            val api: EmrAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Emr = this
            def getBlockPublicAccessConfiguration(
                request: GetBlockPublicAccessConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.GetBlockPublicAccessConfigurationResponse.ReadOnly
            ] = proxy(GetBlockPublicAccessConfiguration, request)
            def listStudioSessionMappings(
                request: ListStudioSessionMappingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.SessionMappingSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListStudioSessionMappings, request))
            def listStudioSessionMappingsPaginated(
                request: ListStudioSessionMappingsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly
            ] = proxy(ListStudioSessionMappingsPaginated, request)
            def createStudio(
                request: CreateStudioRequest
            ): IO[AwsError, zio.aws.emr.model.CreateStudioResponse.ReadOnly] =
              proxy(CreateStudio, request)
            def describeNotebookExecution(
                request: DescribeNotebookExecutionRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly
            ] = proxy(DescribeNotebookExecution, request)
            def stopNotebookExecution(
                request: StopNotebookExecutionRequest
            ): IO[AwsError, Unit] = proxy(StopNotebookExecution, request)
            def listBootstrapActions(
                request: ListBootstrapActionsRequest
            ): ZStream[Any, AwsError, zio.aws.emr.model.Command.ReadOnly] =
              rts.unsafeRun(proxy(ListBootstrapActions, request))
            def listBootstrapActionsPaginated(
                request: ListBootstrapActionsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListBootstrapActionsResponse.ReadOnly
            ] = proxy(ListBootstrapActionsPaginated, request)
            def listReleaseLabels(
                request: ListReleaseLabelsRequest
            ): ZStream[Any, AwsError, String] =
              rts.unsafeRun(proxy(ListReleaseLabels, request))
            def listReleaseLabelsPaginated(
                request: ListReleaseLabelsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly
            ] = proxy(ListReleaseLabelsPaginated, request)
            def setTerminationProtection(
                request: SetTerminationProtectionRequest
            ): IO[AwsError, Unit] = proxy(SetTerminationProtection, request)
            def describeStep(
                request: DescribeStepRequest
            ): IO[AwsError, zio.aws.emr.model.DescribeStepResponse.ReadOnly] =
              proxy(DescribeStep, request)
            def cancelSteps(
                request: CancelStepsRequest
            ): IO[AwsError, zio.aws.emr.model.CancelStepsResponse.ReadOnly] =
              proxy(CancelSteps, request)
            def listInstances(
                request: ListInstancesRequest
            ): ZStream[Any, AwsError, zio.aws.emr.model.Instance.ReadOnly] =
              rts.unsafeRun(proxy(ListInstances, request))
            def listInstancesPaginated(
                request: ListInstancesRequest
            ): IO[AwsError, zio.aws.emr.model.ListInstancesResponse.ReadOnly] =
              proxy(ListInstancesPaginated, request)
            def describeStudio(
                request: DescribeStudioRequest
            ): IO[AwsError, zio.aws.emr.model.DescribeStudioResponse.ReadOnly] =
              proxy(DescribeStudio, request)
            def addTags(
                request: AddTagsRequest
            ): IO[AwsError, zio.aws.emr.model.AddTagsResponse.ReadOnly] =
              proxy(AddTags, request)
            def putAutoScalingPolicy(request: PutAutoScalingPolicyRequest): IO[
              AwsError,
              zio.aws.emr.model.PutAutoScalingPolicyResponse.ReadOnly
            ] = proxy(PutAutoScalingPolicy, request)
            def removeAutoScalingPolicy(
                request: RemoveAutoScalingPolicyRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.RemoveAutoScalingPolicyResponse.ReadOnly
            ] = proxy(RemoveAutoScalingPolicy, request)
            def setVisibleToAllUsers(
                request: SetVisibleToAllUsersRequest
            ): IO[AwsError, Unit] = proxy(SetVisibleToAllUsers, request)
            def getStudioSessionMapping(
                request: GetStudioSessionMappingRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.GetStudioSessionMappingResponse.ReadOnly
            ] = proxy(GetStudioSessionMapping, request)
            def listSecurityConfigurations(
                request: ListSecurityConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.SecurityConfigurationSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListSecurityConfigurations, request))
            def listSecurityConfigurationsPaginated(
                request: ListSecurityConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListSecurityConfigurationsResponse.ReadOnly
            ] = proxy(ListSecurityConfigurationsPaginated, request)
            def deleteStudioSessionMapping(
                request: DeleteStudioSessionMappingRequest
            ): IO[AwsError, Unit] = proxy(DeleteStudioSessionMapping, request)
            def putAutoTerminationPolicy(
                request: PutAutoTerminationPolicyRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.PutAutoTerminationPolicyResponse.ReadOnly
            ] = proxy(PutAutoTerminationPolicy, request)
            def modifyInstanceFleet(
                request: ModifyInstanceFleetRequest
            ): IO[AwsError, Unit] = proxy(ModifyInstanceFleet, request)
            def removeTags(
                request: RemoveTagsRequest
            ): IO[AwsError, zio.aws.emr.model.RemoveTagsResponse.ReadOnly] =
              proxy(RemoveTags, request)
            def listInstanceGroups(request: ListInstanceGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.InstanceGroup.ReadOnly
            ] = rts.unsafeRun(proxy(ListInstanceGroups, request))
            def listInstanceGroupsPaginated(
                request: ListInstanceGroupsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListInstanceGroupsResponse.ReadOnly
            ] = proxy(ListInstanceGroupsPaginated, request)
            def getAutoTerminationPolicy(
                request: GetAutoTerminationPolicyRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.GetAutoTerminationPolicyResponse.ReadOnly
            ] = proxy(GetAutoTerminationPolicy, request)
            def updateStudioSessionMapping(
                request: UpdateStudioSessionMappingRequest
            ): IO[AwsError, Unit] = proxy(UpdateStudioSessionMapping, request)
            def putBlockPublicAccessConfiguration(
                request: PutBlockPublicAccessConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.PutBlockPublicAccessConfigurationResponse.ReadOnly
            ] = proxy(PutBlockPublicAccessConfiguration, request)
            def updateStudio(request: UpdateStudioRequest): IO[AwsError, Unit] =
              proxy(UpdateStudio, request)
            def putManagedScalingPolicy(
                request: PutManagedScalingPolicyRequest
            ): IO[AwsError, ReadOnly] = proxy(PutManagedScalingPolicy, request)
            def listSteps(
                request: ListStepsRequest
            ): ZStream[Any, AwsError, zio.aws.emr.model.StepSummary.ReadOnly] =
              rts.unsafeRun(proxy(ListSteps, request))
            def listStepsPaginated(
                request: ListStepsRequest
            ): IO[AwsError, zio.aws.emr.model.ListStepsResponse.ReadOnly] =
              proxy(ListStepsPaginated, request)
            def listStudios(request: ListStudiosRequest): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.StudioSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListStudios, request))
            def listStudiosPaginated(
                request: ListStudiosRequest
            ): IO[AwsError, zio.aws.emr.model.ListStudiosResponse.ReadOnly] =
              proxy(ListStudiosPaginated, request)
            def addJobFlowSteps(request: AddJobFlowStepsRequest): IO[
              AwsError,
              zio.aws.emr.model.AddJobFlowStepsResponse.ReadOnly
            ] = proxy(AddJobFlowSteps, request)
            def createSecurityConfiguration(
                request: CreateSecurityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.CreateSecurityConfigurationResponse.ReadOnly
            ] = proxy(CreateSecurityConfiguration, request)
            def addInstanceFleet(request: AddInstanceFleetRequest): IO[
              AwsError,
              zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly
            ] = proxy(AddInstanceFleet, request)
            def modifyCluster(
                request: ModifyClusterRequest
            ): IO[AwsError, zio.aws.emr.model.ModifyClusterResponse.ReadOnly] =
              proxy(ModifyCluster, request)
            def deleteSecurityConfiguration(
                request: DeleteSecurityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.DeleteSecurityConfigurationResponse.ReadOnly
            ] = proxy(DeleteSecurityConfiguration, request)
            def createStudioSessionMapping(
                request: CreateStudioSessionMappingRequest
            ): IO[AwsError, Unit] = proxy(CreateStudioSessionMapping, request)
            def describeSecurityConfiguration(
                request: DescribeSecurityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly
            ] = proxy(DescribeSecurityConfiguration, request)
            def describeCluster(request: DescribeClusterRequest): IO[
              AwsError,
              zio.aws.emr.model.DescribeClusterResponse.ReadOnly
            ] = proxy(DescribeCluster, request)
            def listClusters(request: ListClustersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.ClusterSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListClusters, request))
            def listClustersPaginated(
                request: ListClustersRequest
            ): IO[AwsError, zio.aws.emr.model.ListClustersResponse.ReadOnly] =
              proxy(ListClustersPaginated, request)
            def addInstanceGroups(request: AddInstanceGroupsRequest): IO[
              AwsError,
              zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly
            ] = proxy(AddInstanceGroups, request)
            def deleteStudio(request: DeleteStudioRequest): IO[AwsError, Unit] =
              proxy(DeleteStudio, request)
            def runJobFlow(
                request: RunJobFlowRequest
            ): IO[AwsError, zio.aws.emr.model.RunJobFlowResponse.ReadOnly] =
              proxy(RunJobFlow, request)
            def removeAutoTerminationPolicy(
                request: RemoveAutoTerminationPolicyRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.RemoveAutoTerminationPolicyResponse.ReadOnly
            ] = proxy(RemoveAutoTerminationPolicy, request)
            def describeReleaseLabel(
                request: DescribeReleaseLabelRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly,
              String
            ]] = proxy(DescribeReleaseLabel, request)
            def describeReleaseLabelPaginated(
                request: DescribeReleaseLabelRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.DescribeReleaseLabelResponse.ReadOnly
            ] = proxy(DescribeReleaseLabelPaginated, request)
            def startNotebookExecution(
                request: StartNotebookExecutionRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.StartNotebookExecutionResponse.ReadOnly
            ] = proxy(StartNotebookExecution, request)
            def removeManagedScalingPolicy(
                request: RemoveManagedScalingPolicyRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.RemoveManagedScalingPolicyResponse.ReadOnly
            ] = proxy(RemoveManagedScalingPolicy, request)
            def modifyInstanceGroups(
                request: ModifyInstanceGroupsRequest
            ): IO[AwsError, Unit] = proxy(ModifyInstanceGroups, request)
            def listNotebookExecutions(
                request: ListNotebookExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.NotebookExecutionSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListNotebookExecutions, request))
            def listNotebookExecutionsPaginated(
                request: ListNotebookExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly
            ] = proxy(ListNotebookExecutionsPaginated, request)
            def terminateJobFlows(
                request: TerminateJobFlowsRequest
            ): IO[AwsError, Unit] = proxy(TerminateJobFlows, request)
            def listInstanceFleets(request: ListInstanceFleetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.emr.model.InstanceFleet.ReadOnly
            ] = rts.unsafeRun(proxy(ListInstanceFleets, request))
            def listInstanceFleetsPaginated(
                request: ListInstanceFleetsRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly
            ] = proxy(ListInstanceFleetsPaginated, request)
            def getManagedScalingPolicy(
                request: GetManagedScalingPolicyRequest
            ): IO[
              AwsError,
              zio.aws.emr.model.GetManagedScalingPolicyResponse.ReadOnly
            ] = proxy(GetManagedScalingPolicy, request)
          }
        }
      }
    }
  }
}
