package zio.aws.emr
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256, InstanceId}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.emr.model.primitives.Marker.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ArnType extends Subtype[String]
    type ArnType = zio.aws.emr.model.primitives.ArnType.Type
    type BooleanObject = Boolean
    object ClusterId extends Subtype[String]
    type ClusterId = zio.aws.emr.model.primitives.ClusterId.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.emr.model.primitives.Date.Type
    object InstanceFleetId extends Subtype[String]
    type InstanceFleetId = zio.aws.emr.model.primitives.InstanceFleetId.Type
    object InstanceGroupId extends Subtype[String]
    type InstanceGroupId = zio.aws.emr.model.primitives.InstanceGroupId.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.emr.model.primitives.InstanceId.Type
    object InstanceType extends Subtype[String]
    type InstanceType = zio.aws.emr.model.primitives.InstanceType.Type
    type Integer = Int
    object Marker extends Subtype[String]
    type Marker = zio.aws.emr.model.primitives.Marker.Type
    object MaxResultsNumber extends Subtype[Int]
    type MaxResultsNumber = zio.aws.emr.model.primitives.MaxResultsNumber.Type
    object NonNegativeDouble extends Subtype[Double]
    type NonNegativeDouble = zio.aws.emr.model.primitives.NonNegativeDouble.Type
    object OptionalArnType extends Subtype[String]
    type OptionalArnType = zio.aws.emr.model.primitives.OptionalArnType.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.emr.model.primitives.Port.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.emr.model.primitives.ResourceId.Type
    object StepId extends Subtype[String]
    type StepId = zio.aws.emr.model.primitives.StepId.Type
    object WholeNumber extends Subtype[Int]
    type WholeNumber = zio.aws.emr.model.primitives.WholeNumber.Type
    object XmlString extends Subtype[String]
    type XmlString = zio.aws.emr.model.primitives.XmlString.Type
    object XmlStringMaxLen256 extends Subtype[String]
    type XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256.Type
  }
  type ApplicationList = List[zio.aws.emr.model.Application]
  type BootstrapActionConfigList = List[zio.aws.emr.model.BootstrapActionConfig]
  type CancelStepsInfoList = List[zio.aws.emr.model.CancelStepsInfo]
  type ClusterStateList = List[zio.aws.emr.model.ClusterState]
  type ClusterSummaryList = List[zio.aws.emr.model.ClusterSummary]
  type CommandList = List[zio.aws.emr.model.Command]
  type ConfigurationList = List[zio.aws.emr.model.Configuration]
  type EC2InstanceIdsList = List[InstanceId]
  type EC2InstanceIdsToTerminateList = List[InstanceId]
  type EbsBlockDeviceConfigList = List[zio.aws.emr.model.EbsBlockDeviceConfig]
  type EbsBlockDeviceList = List[zio.aws.emr.model.EbsBlockDevice]
  type EbsVolumeList = List[zio.aws.emr.model.EbsVolume]
  type InstanceFleetConfigList = List[zio.aws.emr.model.InstanceFleetConfig]
  type InstanceFleetList = List[zio.aws.emr.model.InstanceFleet]
  type InstanceGroupConfigList = List[zio.aws.emr.model.InstanceGroupConfig]
  type InstanceGroupIdsList = List[XmlStringMaxLen256]
  type InstanceGroupList = List[zio.aws.emr.model.InstanceGroup]
  type InstanceGroupModifyConfigList =
    List[zio.aws.emr.model.InstanceGroupModifyConfig]
  type InstanceGroupTypeList = List[zio.aws.emr.model.InstanceGroupType]
  type InstanceList = List[zio.aws.emr.model.Instance]
  type InstanceStateList = List[zio.aws.emr.model.InstanceState]
  type InstanceTypeConfigList = List[zio.aws.emr.model.InstanceTypeConfig]
  type InstanceTypeSpecificationList =
    List[zio.aws.emr.model.InstanceTypeSpecification]
  type KeyValueList = List[zio.aws.emr.model.KeyValue]
  type MetricDimensionList = List[zio.aws.emr.model.MetricDimension]
  type NewSupportedProductsList = List[zio.aws.emr.model.SupportedProductConfig]
  type NotebookExecutionSummaryList =
    List[zio.aws.emr.model.NotebookExecutionSummary]
  type OSReleaseList = List[zio.aws.emr.model.OSRelease]
  type PlacementGroupConfigList = List[zio.aws.emr.model.PlacementGroupConfig]
  type PortRanges = List[zio.aws.emr.model.PortRange]
  type ScalingRuleList = List[zio.aws.emr.model.ScalingRule]
  type SecurityConfigurationList =
    List[zio.aws.emr.model.SecurityConfigurationSummary]
  type SecurityGroupsList = List[XmlStringMaxLen256]
  type SessionMappingSummaryList = List[zio.aws.emr.model.SessionMappingSummary]
  type SimplifiedApplicationList = List[zio.aws.emr.model.SimplifiedApplication]
  type StepConfigList = List[zio.aws.emr.model.StepConfig]
  type StepIdsList = List[XmlStringMaxLen256]
  type StepStateList = List[zio.aws.emr.model.StepState]
  type StepSummaryList = List[zio.aws.emr.model.StepSummary]
  type StringList = List[String]
  type StringMap = Map[String, String]
  type StudioSummaryList = List[zio.aws.emr.model.StudioSummary]
  type SubnetIdList = List[String]
  type SupportedProductsList = List[XmlStringMaxLen256]
  type TagList = List[zio.aws.emr.model.Tag]
  type XmlStringList = List[XmlString]
  type XmlStringMaxLen256List = List[XmlStringMaxLen256]
}
