package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveManagedScalingPolicyRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest = {
    import RemoveManagedScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.RemoveManagedScalingPolicyRequest.ReadOnly =
    zio.aws.emr.model.RemoveManagedScalingPolicyRequest.wrap(buildAwsValue())
}
object RemoveManagedScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RemoveManagedScalingPolicyRequest =
      zio.aws.emr.model.RemoveManagedScalingPolicyRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest
  ) extends zio.aws.emr.model.RemoveManagedScalingPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest
  ): zio.aws.emr.model.RemoveManagedScalingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
