package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ArnType, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddInstanceGroupsResponse(
    jobFlowId: Optional[XmlStringMaxLen256] = Optional.Absent,
    instanceGroupIds: Optional[Iterable[XmlStringMaxLen256]] = Optional.Absent,
    clusterArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse = {
    import AddInstanceGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
      .builder()
      .optionallyWith(
        jobFlowId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.jobFlowId)
      .optionallyWith(
        instanceGroupIds.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceGroupIds)
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly =
    zio.aws.emr.model.AddInstanceGroupsResponse.wrap(buildAwsValue())
}
object AddInstanceGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddInstanceGroupsResponse =
      zio.aws.emr.model.AddInstanceGroupsResponse(
        jobFlowId.map(value => value),
        instanceGroupIds.map(value => value),
        clusterArn.map(value => value)
      )
    def jobFlowId: Optional[XmlStringMaxLen256]
    def instanceGroupIds: Optional[List[XmlStringMaxLen256]]
    def clusterArn: Optional[ArnType]
    def getJobFlowId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("jobFlowId", jobFlowId)
    def getInstanceGroupIds: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("instanceGroupIds", instanceGroupIds)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
  ) extends zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly {
    override val jobFlowId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.jobFlowId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceGroupIds: Optional[List[XmlStringMaxLen256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
          }.toList
        )
    override val clusterArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse
  ): zio.aws.emr.model.AddInstanceGroupsResponse.ReadOnly = new Wrapper(impl)
}
