package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SupportedProductConfig(
    name: Optional[XmlStringMaxLen256] = Optional.Absent,
    args: Optional[Iterable[XmlString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SupportedProductConfig = {
    import SupportedProductConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SupportedProductConfig
      .builder()
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            XmlString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SupportedProductConfig.ReadOnly =
    zio.aws.emr.model.SupportedProductConfig.wrap(buildAwsValue())
}
object SupportedProductConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SupportedProductConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SupportedProductConfig =
      zio.aws.emr.model.SupportedProductConfig(
        name.map(value => value),
        args.map(value => value)
      )
    def name: Optional[XmlStringMaxLen256]
    def args: Optional[List[XmlString]]
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getArgs: ZIO[Any, AwsError, List[XmlString]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SupportedProductConfig
  ) extends zio.aws.emr.model.SupportedProductConfig.ReadOnly {
    override val name: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val args: Optional[List[XmlString]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SupportedProductConfig
  ): zio.aws.emr.model.SupportedProductConfig.ReadOnly = new Wrapper(impl)
}
