package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KerberosAttributes(
    realm: XmlStringMaxLen256,
    kdcAdminPassword: XmlStringMaxLen256,
    crossRealmTrustPrincipalPassword: Optional[XmlStringMaxLen256] =
      Optional.Absent,
    adDomainJoinUser: Optional[XmlStringMaxLen256] = Optional.Absent,
    adDomainJoinPassword: Optional[XmlStringMaxLen256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.KerberosAttributes = {
    import KerberosAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.KerberosAttributes
      .builder()
      .realm(XmlStringMaxLen256.unwrap(realm): java.lang.String)
      .kdcAdminPassword(
        XmlStringMaxLen256.unwrap(kdcAdminPassword): java.lang.String
      )
      .optionallyWith(
        crossRealmTrustPrincipalPassword.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.crossRealmTrustPrincipalPassword)
      .optionallyWith(
        adDomainJoinUser.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.adDomainJoinUser)
      .optionallyWith(
        adDomainJoinPassword.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.adDomainJoinPassword)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.KerberosAttributes.ReadOnly =
    zio.aws.emr.model.KerberosAttributes.wrap(buildAwsValue())
}
object KerberosAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.KerberosAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.KerberosAttributes =
      zio.aws.emr.model.KerberosAttributes(
        realm,
        kdcAdminPassword,
        crossRealmTrustPrincipalPassword.map(value => value),
        adDomainJoinUser.map(value => value),
        adDomainJoinPassword.map(value => value)
      )
    def realm: XmlStringMaxLen256
    def kdcAdminPassword: XmlStringMaxLen256
    def crossRealmTrustPrincipalPassword: Optional[XmlStringMaxLen256]
    def adDomainJoinUser: Optional[XmlStringMaxLen256]
    def adDomainJoinPassword: Optional[XmlStringMaxLen256]
    def getRealm: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(realm)
    def getKdcAdminPassword: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(kdcAdminPassword)
    def getCrossRealmTrustPrincipalPassword
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "crossRealmTrustPrincipalPassword",
      crossRealmTrustPrincipalPassword
    )
    def getAdDomainJoinUser: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("adDomainJoinUser", adDomainJoinUser)
    def getAdDomainJoinPassword: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("adDomainJoinPassword", adDomainJoinPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.KerberosAttributes
  ) extends zio.aws.emr.model.KerberosAttributes.ReadOnly {
    override val realm: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.realm())
    override val kdcAdminPassword: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.kdcAdminPassword())
    override val crossRealmTrustPrincipalPassword
        : Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.crossRealmTrustPrincipalPassword())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val adDomainJoinUser: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adDomainJoinUser())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val adDomainJoinPassword: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adDomainJoinPassword())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.KerberosAttributes
  ): zio.aws.emr.model.KerberosAttributes.ReadOnly = new Wrapper(impl)
}
