package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Date, XmlStringMaxLen256}
import scala.jdk.CollectionConverters._
final case class SessionMappingSummary(
    studioId: Optional[XmlStringMaxLen256] = Optional.Absent,
    identityId: Optional[XmlStringMaxLen256] = Optional.Absent,
    identityName: Optional[XmlStringMaxLen256] = Optional.Absent,
    identityType: Optional[zio.aws.emr.model.IdentityType] = Optional.Absent,
    sessionPolicyArn: Optional[XmlStringMaxLen256] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SessionMappingSummary = {
    import SessionMappingSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SessionMappingSummary
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        identityId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.identityId)
      .optionallyWith(
        identityName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.identityName)
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        sessionPolicyArn.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.sessionPolicyArn)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SessionMappingSummary.ReadOnly =
    zio.aws.emr.model.SessionMappingSummary.wrap(buildAwsValue())
}
object SessionMappingSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SessionMappingSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SessionMappingSummary =
      zio.aws.emr.model.SessionMappingSummary(
        studioId.map(value => value),
        identityId.map(value => value),
        identityName.map(value => value),
        identityType.map(value => value),
        sessionPolicyArn.map(value => value),
        creationTime.map(value => value)
      )
    def studioId: Optional[XmlStringMaxLen256]
    def identityId: Optional[XmlStringMaxLen256]
    def identityName: Optional[XmlStringMaxLen256]
    def identityType: Optional[zio.aws.emr.model.IdentityType]
    def sessionPolicyArn: Optional[XmlStringMaxLen256]
    def creationTime: Optional[Date]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getIdentityId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getIdentityName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("identityName", identityName)
    def getIdentityType: ZIO[Any, AwsError, zio.aws.emr.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getSessionPolicyArn: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("sessionPolicyArn", sessionPolicyArn)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SessionMappingSummary
  ) extends zio.aws.emr.model.SessionMappingSummary.ReadOnly {
    override val studioId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val identityType: Optional[zio.aws.emr.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.emr.model.IdentityType.wrap(value))
    override val sessionPolicyArn: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionPolicyArn())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SessionMappingSummary
  ): zio.aws.emr.model.SessionMappingSummary.ReadOnly = new Wrapper(impl)
}
