package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStudioSessionMappingsResponse(
    sessionMappings: Optional[
      Iterable[zio.aws.emr.model.SessionMappingSummary]
    ] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse = {
    import ListStudioSessionMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
      .builder()
      .optionallyWith(
        sessionMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessionMappings)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly =
    zio.aws.emr.model.ListStudioSessionMappingsResponse.wrap(buildAwsValue())
}
object ListStudioSessionMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStudioSessionMappingsResponse =
      zio.aws.emr.model.ListStudioSessionMappingsResponse(
        sessionMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def sessionMappings
        : Optional[List[zio.aws.emr.model.SessionMappingSummary.ReadOnly]]
    def marker: Optional[Marker]
    def getSessionMappings: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SessionMappingSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("sessionMappings", sessionMappings)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
  ) extends zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly {
    override val sessionMappings
        : Optional[List[zio.aws.emr.model.SessionMappingSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.SessionMappingSummary.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse
  ): zio.aws.emr.model.ListStudioSessionMappingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
