package zio.aws.emr.model
import zio.aws.emr.model.primitives.{ArnType, Date}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BlockPublicAccessConfigurationMetadata(
    creationDateTime: Date,
    createdByArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.BlockPublicAccessConfigurationMetadata = {
    import BlockPublicAccessConfigurationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.BlockPublicAccessConfigurationMetadata
      .builder()
      .creationDateTime(Date.unwrap(creationDateTime): Instant)
      .createdByArn(ArnType.unwrap(createdByArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.BlockPublicAccessConfigurationMetadata.ReadOnly =
    zio.aws.emr.model.BlockPublicAccessConfigurationMetadata
      .wrap(buildAwsValue())
}
object BlockPublicAccessConfigurationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.BlockPublicAccessConfigurationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.BlockPublicAccessConfigurationMetadata =
      zio.aws.emr.model
        .BlockPublicAccessConfigurationMetadata(creationDateTime, createdByArn)
    def creationDateTime: Date
    def createdByArn: ArnType
    def getCreationDateTime: ZIO[Any, Nothing, Date] =
      ZIO.succeed(creationDateTime)
    def getCreatedByArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(createdByArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.BlockPublicAccessConfigurationMetadata
  ) extends zio.aws.emr.model.BlockPublicAccessConfigurationMetadata.ReadOnly {
    override val creationDateTime: Date =
      zio.aws.emr.model.primitives.Date(impl.creationDateTime())
    override val createdByArn: ArnType =
      zio.aws.emr.model.primitives.ArnType(impl.createdByArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.BlockPublicAccessConfigurationMetadata
  ): zio.aws.emr.model.BlockPublicAccessConfigurationMetadata.ReadOnly =
    new Wrapper(impl)
}
