package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeLimits(
    unitType: zio.aws.emr.model.ComputeLimitsUnitType,
    minimumCapacityUnits: Integer,
    maximumCapacityUnits: Integer,
    maximumOnDemandCapacityUnits: Optional[Integer] = Optional.Absent,
    maximumCoreCapacityUnits: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ComputeLimits = {
    import ComputeLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ComputeLimits
      .builder()
      .unitType(unitType.unwrap)
      .minimumCapacityUnits(minimumCapacityUnits: java.lang.Integer)
      .maximumCapacityUnits(maximumCapacityUnits: java.lang.Integer)
      .optionallyWith(
        maximumOnDemandCapacityUnits.map(value => value: java.lang.Integer)
      )(_.maximumOnDemandCapacityUnits)
      .optionallyWith(
        maximumCoreCapacityUnits.map(value => value: java.lang.Integer)
      )(_.maximumCoreCapacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ComputeLimits.ReadOnly =
    zio.aws.emr.model.ComputeLimits.wrap(buildAwsValue())
}
object ComputeLimits {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ComputeLimits] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ComputeLimits =
      zio.aws.emr.model.ComputeLimits(
        unitType,
        minimumCapacityUnits,
        maximumCapacityUnits,
        maximumOnDemandCapacityUnits.map(value => value),
        maximumCoreCapacityUnits.map(value => value)
      )
    def unitType: zio.aws.emr.model.ComputeLimitsUnitType
    def minimumCapacityUnits: Integer
    def maximumCapacityUnits: Integer
    def maximumOnDemandCapacityUnits: Optional[Integer]
    def maximumCoreCapacityUnits: Optional[Integer]
    def getUnitType
        : ZIO[Any, Nothing, zio.aws.emr.model.ComputeLimitsUnitType] =
      ZIO.succeed(unitType)
    def getMinimumCapacityUnits: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(minimumCapacityUnits)
    def getMaximumCapacityUnits: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(maximumCapacityUnits)
    def getMaximumOnDemandCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "maximumOnDemandCapacityUnits",
        maximumOnDemandCapacityUnits
      )
    def getMaximumCoreCapacityUnits: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maximumCoreCapacityUnits", maximumCoreCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ComputeLimits
  ) extends zio.aws.emr.model.ComputeLimits.ReadOnly {
    override val unitType: zio.aws.emr.model.ComputeLimitsUnitType =
      zio.aws.emr.model.ComputeLimitsUnitType.wrap(impl.unitType())
    override val minimumCapacityUnits: Integer =
      impl.minimumCapacityUnits(): Integer
    override val maximumCapacityUnits: Integer =
      impl.maximumCapacityUnits(): Integer
    override val maximumOnDemandCapacityUnits: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumOnDemandCapacityUnits())
        .map(value => value: Integer)
    override val maximumCoreCapacityUnits: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumCoreCapacityUnits())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ComputeLimits
  ): zio.aws.emr.model.ComputeLimits.ReadOnly = new Wrapper(impl)
}
