package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionEngineType {
  def unwrap: software.amazon.awssdk.services.emr.model.ExecutionEngineType
}
object ExecutionEngineType {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ExecutionEngineType
  ): zio.aws.emr.model.ExecutionEngineType = value match {
    case software.amazon.awssdk.services.emr.model.ExecutionEngineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ExecutionEngineType.EMR =>
      val r = EMR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.ExecutionEngineType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ExecutionEngineType =
      software.amazon.awssdk.services.emr.model.ExecutionEngineType.UNKNOWN_TO_SDK_VERSION
  }
  case object EMR extends zio.aws.emr.model.ExecutionEngineType {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ExecutionEngineType =
      software.amazon.awssdk.services.emr.model.ExecutionEngineType.EMR
  }
}
