package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  ArnType,
  InstanceFleetId,
  XmlStringMaxLen256
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddInstanceFleetResponse(
    clusterId: Optional[XmlStringMaxLen256] = Optional.Absent,
    instanceFleetId: Optional[InstanceFleetId] = Optional.Absent,
    clusterArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse = {
    import AddInstanceFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
      .builder()
      .optionallyWith(
        clusterId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.clusterId)
      .optionallyWith(
        instanceFleetId.map(value =>
          InstanceFleetId.unwrap(value): java.lang.String
        )
      )(_.instanceFleetId)
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly =
    zio.aws.emr.model.AddInstanceFleetResponse.wrap(buildAwsValue())
}
object AddInstanceFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddInstanceFleetResponse =
      zio.aws.emr.model.AddInstanceFleetResponse(
        clusterId.map(value => value),
        instanceFleetId.map(value => value),
        clusterArn.map(value => value)
      )
    def clusterId: Optional[XmlStringMaxLen256]
    def instanceFleetId: Optional[InstanceFleetId]
    def clusterArn: Optional[ArnType]
    def getClusterId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getInstanceFleetId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("instanceFleetId", instanceFleetId)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
  ) extends zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly {
    override val clusterId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceFleetId: Optional[InstanceFleetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceFleetId())
        .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val clusterArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
  ): zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly = new Wrapper(impl)
}
