package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddInstanceFleetRequest(
    clusterId: XmlStringMaxLen256,
    instanceFleet: zio.aws.emr.model.InstanceFleetConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest = {
    import AddInstanceFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest
      .builder()
      .clusterId(XmlStringMaxLen256.unwrap(clusterId): java.lang.String)
      .instanceFleet(instanceFleet.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddInstanceFleetRequest.ReadOnly =
    zio.aws.emr.model.AddInstanceFleetRequest.wrap(buildAwsValue())
}
object AddInstanceFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddInstanceFleetRequest =
      zio.aws.emr.model
        .AddInstanceFleetRequest(clusterId, instanceFleet.asEditable)
    def clusterId: XmlStringMaxLen256
    def instanceFleet: zio.aws.emr.model.InstanceFleetConfig.ReadOnly
    def getClusterId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(clusterId)
    def getInstanceFleet
        : ZIO[Any, Nothing, zio.aws.emr.model.InstanceFleetConfig.ReadOnly] =
      ZIO.succeed(instanceFleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest
  ) extends zio.aws.emr.model.AddInstanceFleetRequest.ReadOnly {
    override val clusterId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.clusterId())
    override val instanceFleet: zio.aws.emr.model.InstanceFleetConfig.ReadOnly =
      zio.aws.emr.model.InstanceFleetConfig.wrap(impl.instanceFleet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest
  ): zio.aws.emr.model.AddInstanceFleetRequest.ReadOnly = new Wrapper(impl)
}
