package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.Date
import scala.jdk.CollectionConverters._
final case class StepTimeline(
    creationDateTime: Optional[Date] = Optional.Absent,
    startDateTime: Optional[Date] = Optional.Absent,
    endDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StepTimeline = {
    import StepTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepTimeline
      .builder()
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(startDateTime.map(value => Date.unwrap(value): Instant))(
        _.startDateTime
      )
      .optionallyWith(endDateTime.map(value => Date.unwrap(value): Instant))(
        _.endDateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepTimeline.ReadOnly =
    zio.aws.emr.model.StepTimeline.wrap(buildAwsValue())
}
object StepTimeline {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepTimeline] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepTimeline =
      zio.aws.emr.model.StepTimeline(
        creationDateTime.map(value => value),
        startDateTime.map(value => value),
        endDateTime.map(value => value)
      )
    def creationDateTime: Optional[Date]
    def startDateTime: Optional[Date]
    def endDateTime: Optional[Date]
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getStartDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepTimeline
  ) extends zio.aws.emr.model.StepTimeline.ReadOnly {
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val startDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepTimeline
  ): zio.aws.emr.model.StepTimeline.ReadOnly = new Wrapper(impl)
}
