package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StepStateChangeReason(
    code: Optional[zio.aws.emr.model.StepStateChangeReasonCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StepStateChangeReason = {
    import StepStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepStateChangeReason.ReadOnly =
    zio.aws.emr.model.StepStateChangeReason.wrap(buildAwsValue())
}
object StepStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.StepStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepStateChangeReason =
      zio.aws.emr.model.StepStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.emr.model.StepStateChangeReasonCode]
    def message: Optional[String]
    def getCode
        : ZIO[Any, AwsError, zio.aws.emr.model.StepStateChangeReasonCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepStateChangeReason
  ) extends zio.aws.emr.model.StepStateChangeReason.ReadOnly {
    override val code: Optional[zio.aws.emr.model.StepStateChangeReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.emr.model.StepStateChangeReasonCode.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepStateChangeReason
  ): zio.aws.emr.model.StepStateChangeReason.ReadOnly = new Wrapper(impl)
}
