package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StepConfig(
    name: XmlStringMaxLen256,
    actionOnFailure: Optional[zio.aws.emr.model.ActionOnFailure] =
      Optional.Absent,
    hadoopJarStep: zio.aws.emr.model.HadoopJarStepConfig
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.StepConfig = {
    import StepConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StepConfig
      .builder()
      .name(XmlStringMaxLen256.unwrap(name): java.lang.String)
      .optionallyWith(actionOnFailure.map(value => value.unwrap))(
        _.actionOnFailure
      )
      .hadoopJarStep(hadoopJarStep.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StepConfig.ReadOnly =
    zio.aws.emr.model.StepConfig.wrap(buildAwsValue())
}
object StepConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StepConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StepConfig = zio.aws.emr.model.StepConfig(
      name,
      actionOnFailure.map(value => value),
      hadoopJarStep.asEditable
    )
    def name: XmlStringMaxLen256
    def actionOnFailure: Optional[zio.aws.emr.model.ActionOnFailure]
    def hadoopJarStep: zio.aws.emr.model.HadoopJarStepConfig.ReadOnly
    def getName: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(name)
    def getActionOnFailure
        : ZIO[Any, AwsError, zio.aws.emr.model.ActionOnFailure] =
      AwsError.unwrapOptionField("actionOnFailure", actionOnFailure)
    def getHadoopJarStep
        : ZIO[Any, Nothing, zio.aws.emr.model.HadoopJarStepConfig.ReadOnly] =
      ZIO.succeed(hadoopJarStep)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StepConfig
  ) extends zio.aws.emr.model.StepConfig.ReadOnly {
    override val name: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.name())
    override val actionOnFailure: Optional[zio.aws.emr.model.ActionOnFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionOnFailure())
        .map(value => zio.aws.emr.model.ActionOnFailure.wrap(value))
    override val hadoopJarStep: zio.aws.emr.model.HadoopJarStepConfig.ReadOnly =
      zio.aws.emr.model.HadoopJarStepConfig.wrap(impl.hadoopJarStep())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StepConfig
  ): zio.aws.emr.model.StepConfig.ReadOnly = new Wrapper(impl)
}
