package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{Date, XmlString}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityConfigurationResponse(
    name: Optional[XmlString] = Optional.Absent,
    securityConfiguration: Optional[String] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse = {
    import DescribeSecurityConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse
      .builder()
      .optionallyWith(
        name.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        securityConfiguration.map(value => value: java.lang.String)
      )(_.securityConfiguration)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly =
    zio.aws.emr.model.DescribeSecurityConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeSecurityConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeSecurityConfigurationResponse =
      zio.aws.emr.model.DescribeSecurityConfigurationResponse(
        name.map(value => value),
        securityConfiguration.map(value => value),
        creationDateTime.map(value => value)
      )
    def name: Optional[XmlString]
    def securityConfiguration: Optional[String]
    def creationDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityConfiguration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("securityConfiguration", securityConfiguration)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse
  ) extends zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly {
    override val name: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val securityConfiguration: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.securityConfiguration())
      .map(value => value: String)
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse
  ): zio.aws.emr.model.DescribeSecurityConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
