package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelStepsRequest(
    clusterId: XmlStringMaxLen256,
    stepIds: Iterable[XmlStringMaxLen256],
    stepCancellationOption: Optional[zio.aws.emr.model.StepCancellationOption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CancelStepsRequest = {
    import CancelStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CancelStepsRequest
      .builder()
      .clusterId(XmlStringMaxLen256.unwrap(clusterId): java.lang.String)
      .stepIds(stepIds.map { item =>
        XmlStringMaxLen256.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(stepCancellationOption.map(value => value.unwrap))(
        _.stepCancellationOption
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CancelStepsRequest.ReadOnly =
    zio.aws.emr.model.CancelStepsRequest.wrap(buildAwsValue())
}
object CancelStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CancelStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CancelStepsRequest =
      zio.aws.emr.model.CancelStepsRequest(
        clusterId,
        stepIds,
        stepCancellationOption.map(value => value)
      )
    def clusterId: XmlStringMaxLen256
    def stepIds: List[XmlStringMaxLen256]
    def stepCancellationOption
        : Optional[zio.aws.emr.model.StepCancellationOption]
    def getClusterId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(clusterId)
    def getStepIds: ZIO[Any, Nothing, List[XmlStringMaxLen256]] =
      ZIO.succeed(stepIds)
    def getStepCancellationOption
        : ZIO[Any, AwsError, zio.aws.emr.model.StepCancellationOption] =
      AwsError.unwrapOptionField(
        "stepCancellationOption",
        stepCancellationOption
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsRequest
  ) extends zio.aws.emr.model.CancelStepsRequest.ReadOnly {
    override val clusterId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.clusterId())
    override val stepIds: List[XmlStringMaxLen256] = impl
      .stepIds()
      .asScala
      .map { item =>
        zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
      }
      .toList
    override val stepCancellationOption
        : Optional[zio.aws.emr.model.StepCancellationOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepCancellationOption())
        .map(value => zio.aws.emr.model.StepCancellationOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsRequest
  ): zio.aws.emr.model.CancelStepsRequest.ReadOnly = new Wrapper(impl)
}
