package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BootstrapActionConfig(
    name: XmlStringMaxLen256,
    scriptBootstrapAction: zio.aws.emr.model.ScriptBootstrapActionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.BootstrapActionConfig = {
    import BootstrapActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.BootstrapActionConfig
      .builder()
      .name(XmlStringMaxLen256.unwrap(name): java.lang.String)
      .scriptBootstrapAction(scriptBootstrapAction.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.BootstrapActionConfig.ReadOnly =
    zio.aws.emr.model.BootstrapActionConfig.wrap(buildAwsValue())
}
object BootstrapActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.BootstrapActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.BootstrapActionConfig = zio.aws.emr.model
      .BootstrapActionConfig(name, scriptBootstrapAction.asEditable)
    def name: XmlStringMaxLen256
    def scriptBootstrapAction
        : zio.aws.emr.model.ScriptBootstrapActionConfig.ReadOnly
    def getName: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(name)
    def getScriptBootstrapAction: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.ScriptBootstrapActionConfig.ReadOnly
    ] = ZIO.succeed(scriptBootstrapAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.BootstrapActionConfig
  ) extends zio.aws.emr.model.BootstrapActionConfig.ReadOnly {
    override val name: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.name())
    override val scriptBootstrapAction
        : zio.aws.emr.model.ScriptBootstrapActionConfig.ReadOnly =
      zio.aws.emr.model.ScriptBootstrapActionConfig
        .wrap(impl.scriptBootstrapAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.BootstrapActionConfig
  ): zio.aws.emr.model.BootstrapActionConfig.ReadOnly = new Wrapper(impl)
}
