package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopNotebookExecutionRequest(
    notebookExecutionId: XmlStringMaxLen256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest = {
    import StopNotebookExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest
      .builder()
      .notebookExecutionId(
        XmlStringMaxLen256.unwrap(notebookExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StopNotebookExecutionRequest.ReadOnly =
    zio.aws.emr.model.StopNotebookExecutionRequest.wrap(buildAwsValue())
}
object StopNotebookExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StopNotebookExecutionRequest =
      zio.aws.emr.model.StopNotebookExecutionRequest(notebookExecutionId)
    def notebookExecutionId: XmlStringMaxLen256
    def getNotebookExecutionId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(notebookExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest
  ) extends zio.aws.emr.model.StopNotebookExecutionRequest.ReadOnly {
    override val notebookExecutionId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives
        .XmlStringMaxLen256(impl.notebookExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest
  ): zio.aws.emr.model.StopNotebookExecutionRequest.ReadOnly = new Wrapper(impl)
}
