package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{WholeNumber, InstanceFleetId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceFleetModifyConfig(
    instanceFleetId: InstanceFleetId,
    targetOnDemandCapacity: Optional[WholeNumber] = Optional.Absent,
    targetSpotCapacity: Optional[WholeNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig = {
    import InstanceFleetModifyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
      .builder()
      .instanceFleetId(
        InstanceFleetId.unwrap(instanceFleetId): java.lang.String
      )
      .optionallyWith(
        targetOnDemandCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetOnDemandCapacity)
      .optionallyWith(
        targetSpotCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.targetSpotCapacity)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly =
    zio.aws.emr.model.InstanceFleetModifyConfig.wrap(buildAwsValue())
}
object InstanceFleetModifyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetModifyConfig =
      zio.aws.emr.model.InstanceFleetModifyConfig(
        instanceFleetId,
        targetOnDemandCapacity.map(value => value),
        targetSpotCapacity.map(value => value)
      )
    def instanceFleetId: InstanceFleetId
    def targetOnDemandCapacity: Optional[WholeNumber]
    def targetSpotCapacity: Optional[WholeNumber]
    def getInstanceFleetId: ZIO[Any, Nothing, InstanceFleetId] =
      ZIO.succeed(instanceFleetId)
    def getTargetOnDemandCapacity: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("targetOnDemandCapacity", targetOnDemandCapacity)
    def getTargetSpotCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("targetSpotCapacity", targetSpotCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ) extends zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly {
    override val instanceFleetId: InstanceFleetId =
      zio.aws.emr.model.primitives.InstanceFleetId(impl.instanceFleetId())
    override val targetOnDemandCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetOnDemandCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val targetSpotCapacity: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSpotCapacity())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig
  ): zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly = new Wrapper(impl)
}
